/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.client.gui.screens.BCLibLayoutScreen;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.networking.VersionChecker;

@Environment(value=EnvType.CLIENT)
public class UpdatesScreen
extends BCLibLayoutScreen {
    public static final String DONATION_URL = "https://www.buymeacoffee.com/quiqueck";
    static final ResourceLocation UPDATE_LOGO_LOCATION = new ResourceLocation("bclib", "icon_updater.png");

    public UpdatesScreen(Screen parent) {
        super(parent, (Component)Component.m_237115_((String)"bclib.updates.title"), 10, 10, 10);
    }

    public static void showUpdateUI() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> Minecraft.m_91087_().m_91152_((Screen)new UpdatesScreen(Minecraft.m_91087_().f_91080_)));
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new UpdatesScreen(Minecraft.m_91087_().f_91080_));
        }
    }

    public ResourceLocation getUpdaterIcon(String modID) {
        CustomValue.CvObject obj;
        CustomValue element;
        if (modID.equals("bclib")) {
            return UPDATE_LOGO_LOCATION;
        }
        ModContainer nfo = FabricLoader.getInstance().getModContainer(modID).orElse(null);
        if (nfo != null && (element = nfo.getMetadata().getCustomValue("bclib")) != null && (obj = element.getAsObject()) != null) {
            CustomValue icon = obj.get("updater_icon");
            return new ResourceLocation(modID, icon.getAsString());
        }
        return null;
    }

    protected LayoutComponent<?, ?> initContent() {
        VerticalStack rows = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fit()).centerHorizontal();
        rows.addMultilineText(UpdatesScreen.fill(), UpdatesScreen.fit(), (Component)Component.m_237115_((String)"bclib.updates.description")).centerHorizontal();
        rows.addSpacer(8);
        VersionChecker.forEachUpdate((mod, cur, updated) -> {
            ModContainer nfo = FabricLoader.getInstance().getModContainer(mod).orElse(null);
            ResourceLocation icon = this.getUpdaterIcon(mod);
            HorizontalStack row = (HorizontalStack)rows.addRow(UpdatesScreen.fixed((int)320), UpdatesScreen.fit()).centerHorizontal();
            if (icon != null) {
                row.addImage(Value.fit(), Value.fit(), icon, Size.of((int)32));
                row.addSpacer(4);
            } else {
                row.addSpacer(36);
            }
            if (nfo != null) {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237113_((String)nfo.getMetadata().getName())).setColor(ColorHelper.WHITE);
            } else {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237113_((String)mod)).setColor(ColorHelper.WHITE);
            }
            row.addSpacer(4);
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237113_((String)cur));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237113_((String)" -> "));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237113_((String)updated)).setColor(ColorHelper.GREEN);
            row.addFiller();
            boolean createdDownloadLink = false;
            if (nfo != null && nfo.getMetadata().getCustomValue("bclib") != null && nfo.getMetadata().getCustomValue("bclib").getAsObject().get("downloads") != null) {
                CustomValue.CvObject downloadLinks = nfo.getMetadata().getCustomValue("bclib").getAsObject().get("downloads").getAsObject();
                String link = null;
                MutableComponent name = null;
                if (Configs.CLIENT_CONFIG.preferModrinthForUpdates() && downloadLinks.get("modrinth") != null) {
                    link = downloadLinks.get("modrinth").getAsString();
                    name = Component.m_237115_((String)"bclib.updates.modrinth_link");
                } else if (downloadLinks.get("curseforge") != null) {
                    link = downloadLinks.get("curseforge").getAsString();
                    name = Component.m_237115_((String)"bclib.updates.curseforge_link");
                }
                if (link != null) {
                    createdDownloadLink = true;
                    String finalLink = link;
                    row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)name).onPress(bt -> this.openLink(finalLink)).centerVertical();
                }
            }
            if (!createdDownloadLink && nfo != null && nfo.getMetadata().getContact().get("homepage").isPresent()) {
                row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237115_((String)"bclib.updates.download_link")).onPress(bt -> this.openLink((String)nfo.getMetadata().getContact().get("homepage").get())).centerVertical();
            }
        });
        VerticalStack layout = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fill()).centerHorizontal();
        layout.addScrollable((LayoutComponent)rows);
        layout.addSpacer(8);
        HorizontalStack footer = layout.addRow(UpdatesScreen.fill(), UpdatesScreen.fit());
        if (Configs.CLIENT_CONFIG.isDonor()) {
            footer.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237115_((String)"bclib.updates.donate").m_6270_(Style.f_131099_.m_178520_(ColorHelper.YELLOW))).onPress(bt -> this.openLink(DONATION_URL));
            footer.addSpacer(2);
            footer.addMultilineText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237115_((String)"bclib.updates.donate_pre")).alignBottom();
        }
        footer.addFiller();
        footer.addCheckbox(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.m_237115_((String)"Disable Check"), !Configs.CLIENT_CONFIG.checkVersions()).onChange((cb, state) -> {
            Configs.CLIENT_CONFIG.setCheckVersions(!state);
            Configs.CLIENT_CONFIG.saveChanges();
        });
        footer.addSpacer(4);
        footer.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), CommonComponents.f_130655_).onPress(bt -> this.m_7379_());
        return layout;
    }

    protected void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1120652220);
    }
}

